IF EXISTS (SELECT
						 *
					 FROM
						 SYS.VIEWS
					 WHERE
						OBJECT_ID = OBJECT_ID(N'[DBO].[V_PDV_VD_VENDAS_GERAL]'))
	DROP VIEW [DBO].[V_PDV_VD_VENDAS_GERAL]

GO
CREATE VIEW V_PDV_VD_VENDAS_GERAL
AS
SELECT 
	i.CD_EMP,
	i.CD_PROD,
    i.CD_FILIAL,
    i.QT_IT,
    i.TOT_IT,
	i.DT_VD,
	'CUPOM FISCAL' AS TIPO_VENDA
FROM 
	PDV_VD V INNER JOIN PDV_VD_IT I ON 
	V.CD_EMP    = I.CD_EMP AND
	V.CD_FILIAL = I.CD_FILIAL AND
	V.CD_VD     = I.CD_VD AND
	V.DT_VD     = I.DT_VD
WHERE
	V.ST_VD =0  
	AND i.ST_IT = 1 
UNION ALL
SELECT 
	i.CD_EMP,
	i.CD_PROD,
    i.CD_FILIAL,
    i.QT_IT,
    (i.VLR_TOT_IT - VLR_DESC_IT) AS VLR_TOT_IT,
	i.DT_EMI_NF,
	'NOTA FISCAL' AS TIPO_VENDA
FROM 
	EST_NF_SAI V INNER JOIN EST_NF_SAI_IT I ON 
	V.CD_EMP    = I.CD_EMP AND
	V.CD_FILIAL = I.CD_FILIAL AND
	V.CD_NF     = I.CD_NF AND
	V.DT_EMI_NF     = I.DT_EMI_NF
	INNER JOIN EST_NF_SAI_VENDAS VN ON 
	V.CD_EMP    = VN.CD_EMP AND
	V.CD_FILIAL = VN.CD_FILIAL AND
	V.CD_NF     = VN.CD_NF 
WHERE
	V.CD_EMP =1
	AND V.STS_NF =0  


